* Title: 	figure8.do
* Version: 	23 May 2018
* Purpose: 	Produce map of prime male joblessness, 1980


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure8, text replace
set more off
clear all
macro drop _all

* Install maptile geography
maptile_install using dta/maptile_conspuma.zip, replace


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip conspuma PrimeMaleD UnempB perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 1980 Census
keep if year == 1980


*******************************************************************************
* (2) Construct joblessness rates by PUMA
*******************************************************************************

collapse (sum) Total = PrimeMaleD Jobless = UnempB ///
		 [pw=perwt], by(statefip conspuma)

gen Jobless_Rate_1980 = 100 * (Jobless/Total)

keep statefip conspuma Jobless_Rate_1980

* Save dataset
compress
save output/figures/dta/figure8.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

maptile	Jobless_Rate_1980, geo(conspuma) conus ///
		cutvalues(10(4)26) ///
		twopt  (legend(title("Not Working Rate, percent", size(vsmall)) ///
				lab(2 "< 10")  ///
				lab(3 "10 - 14")  ///
				lab(4 "14 - 18")  ///
				lab(5 "18 - 22")  ///
				lab(6 "22 - 26")  ///
				lab(7 "> 26")))

graph save output/figures/gph/figure8, replace
graph export output/figures/eps/figure8.eps, as(eps) replace
export excel using output/figures/xlsx/figure8.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
